.TH PINMAP_START 8V  "" "Valid Logic"
.SH NAME
pinmap_start \- utility for creating starter pin map files for 
\fBgedifnet\fP, \fBgedifsym\fP, and \fBread_edif\fP

.SH SYNOPSIS
.ie \n(VX \{
.B pinmap :== $scald$root:[read_edif]pinmap_start
.br
.B pinmap_start
\}
.el \{
.B /usr/valid/tools/bin/pinmap_start
\}
ChipsFile ... > PinMapFile
.SH DESCRIPTION
.LP
.I Pinmap_start
takes chips files and generates a pin map file that makes a first guess about how
the Valid parts given in the chips file will map to parts from Synopsys.
The resulting file should then be hand edited to produce a correct mapping. 
The idea is to give the librarian a place to start other than from scratch.
.LP
The resulting file maps from Valid to Synopsys so the \fIread_edif\fP 
\fBPIN_MAP_FILE\fP directive
must be specified with a '-' to reverse this sense to go from Synopsys to Valid.
(see \fBgedifnet.man\fP, or \fBgedifsym.man\fP, or \fBread_edif.man\fP 
for information on this directive.)
.LP
Note that the chips files are specified as arguments and the resulting pin map
file goes to standard out.
.SH HEURISTICS
.LP
.I Pinmap_start
maps pin names as follows:
.IP 1.
If the Valid pin is low-asserted and no high-asserted pin of the same name exists, then
the pin is made high-asserted on the Synopsys side.
.IP 2.
If the Valid pin is a single bit vector with only bit 0, then it is made a scalar
on the Synopsys side.
.IP 3.
If the Valid pin is part of a multiple-bit vector, then it is made a scalar
on the Synopsys side with
its bit number converted
to a suffix on the name.  ('A'<3> becomes 'A.3').
.LP
Parts that have vector pins that have "missing" bits are silently ignored.
.SH FILES
.br
.nf
\fIPinMapFile\fP (output)
\fIChipsFile(s)\fP (input)
.fi
.SH DIAGNOSTICS
.LP
Syntax errors in the chips files
are reported as such, with line number.  These are usually fatal.
.LP
The program exits with the number of errors encountered as its exit code.
.SH EXAMPLE
From within the directory containing the mx1000 library (a made-up library name)
utter the following: 
.IP 
.ie \n(VX \{
.br
pinmap :== $scald$root:[read_edif]pinmap_start
.br
pinmap_start [.*]chips_prt.dat
.br
DON'T KNOW HOW TO REDIRECT
\}
.RS
.RS
/usr/valid/tools/bin/pinmap_start */chips_prt >mx1000.pinmap
.RE
.RE
.LP
Then hand edit mx1000.pinmap to make corrections.
.SH SEE ALSO
.LP
\fBgedifnet.man\fP, \fBgedifsym.man\fP, \fBread_edif.man\fP
